from cryptography.fernet import Fernet
import base64
import os
import hashlib

def derive_key_pbkdf2(master_password: str, salt: bytes, iterations: int = 100_000) -> bytes:
    key = hashlib.pbkdf2_hmac('sha256', master_password.encode(), salt, iterations, dklen=32)
    return base64.urlsafe_b64encode(key)

master_password = input("Enter master password (MUST BE REMEMBERED!!): ")
verify_master_password = input("Re-enter master password: ")
if master_password != verify_master_password:
    print("The passwords don't match.")
    exit(1)

lxca_plain_password = input("\nEnter the LXCA password to encrypt: ")
verify_lxca_plain_password = input("Re-enter the LXCA password: ")
if lxca_plain_password != verify_lxca_plain_password:
    print("The passwords don't match.")
    exit(1)

pve_plain_password = input("\nEnter the Proxmox password to encrypt: ")
verify_pve_plain_password = input("Re-enter the LXCA password: ")
if pve_plain_password != verify_pve_plain_password:
    print("The passwords don't match.")
    exit(1)

salt = os.urandom(16)
key = derive_key_pbkdf2(master_password, salt)
fernet = Fernet(key)

lxca_encrypted_password = fernet.encrypt(lxca_plain_password.encode()).decode()
pve_encrypted_password = fernet.encrypt(pve_plain_password.encode()).decode()
encoded_salt = base64.b64encode(salt).decode()

print("\nAdd the following three lines to your config.ini:\n")
print(f"LXCA_PASS = {lxca_encrypted_password}")
print(f"PROXMOX_PASS = {pve_encrypted_password}")
print(f"SALT = {encoded_salt}")
